#include <WiFi.h>
#include <WiFiClient.h>
#include <WiFiAP.h>

#include <Arduino.h>
#include <Wire.h>
#include <Adafruit_PWMServoDriver.h>
#include "settings.h"

Adafruit_PWMServoDriver pwm = Adafruit_PWMServoDriver();

WiFiServer server(80);

boolean homed = false;

struct endstop {
  const uint8_t PIN;
  uint32_t numberKeyPresses;
  boolean pressed;
};

endstop end1 = {endstop_pin, 0, false};

// everytime an interrupt has been recognized, number will be count up and "pressed" will be true to call next function
void IRAM_ATTR isr() {
  //end1.numberKeyPresses += 1;
  end1.pressed = true;
}

void setup() {
  Serial.begin(115200);
  delay(1000);
  Serial.println("WANNA DRINK SOMETHING?");

  // init onboard LED for debugging
  //  pinMode(LED_BUILTIN, OUTPUT);

  // init motor pins
  pinMode(stepPin, OUTPUT);
  pinMode(dirPin, OUTPUT);
  pinMode(enablePin, OUTPUT);

  for (uint8_t i = 0; i  < 7; i++) {
    pinMode( pumps[i], OUTPUT);
    delay(100);
    digitalWrite(pumps[i], LOW);
  }

  // SERVO PCA9685
  pwm.begin();
  pwm.setPWMFreq(60);  // Analog servos run at ~60 Hz updates
  delay(10);

  // WIFI
  // You can remove the password parameter if you want the AP to be open.
  WiFi.softAP(ssid, password);
  IPAddress myIP = WiFi.softAPIP();
  Serial.print("AP IP address: ");
  Serial.println(myIP);
  server.begin();

  Serial.println("Server started");

  // ENDSTOP
  pinMode(end1.PIN, INPUT);
  attachInterrupt(end1.PIN, isr, FALLING);

}

uint16_t count = 0;

void loop() {
  //checkClient();

  // first, check if any endstop has been hit before action will start
  static uint32_t lastMillis = 0;

  if (end1.pressed) {// && millis() - lastMillis > debounceTime_endstop) {
    Serial.printf("ENDSTOP 1 has been pressed %u times\n", end1.numberKeyPresses);
    end1.pressed = false;
    homed = true;
  }
  if (homed == false) {

    digitalWrite(enablePin, LOW); // Enables the motor to move in a particular direction
    //delay(10);
    digitalWrite(dirPin, 0); // Enables the motor to move in a particular direction

    digitalWrite(stepPin, HIGH);
    delayMicroseconds(70);
    digitalWrite(stepPin, LOW);
    delayMicroseconds(70);
  }

  else {
    digitalWrite(enablePin, HIGH); // Enables the motor to move in a particular direction
    checkClient();

  }
}


void checkClient() {
  // WIFI ACTION
  WiFiClient client = server.available();   // listen for incoming clients

  if (client && cocktailReady == true) {                             // if you get a client,

    Serial.println("New Client.");           // print a message out the serial port
    count = 0;
    String currentLine = "";                // make a String to hold incoming data from the client
    while (client.connected()) {            // loop while the client's connected
      if (client.available()) {             // if there's bytes to read from the client,
        char c = client.read();             // read a byte, then
        Serial.write(c);                    // print it out the serial monitor
        if (c == '\n') {                    // if the byte is a newline character

          // if the current line is blank, you got two newline characters in a row.
          // that's the end of the client HTTP request, so send a response:
          if (currentLine.length() == 0) {
            // HTTP headers always start with a response code (e.g. HTTP/1.1 200 OK)
            // and a content-type so the client knows what's coming, then a blank line:
            client.println("HTTP/1.1 200 OK");
            client.println("Content-type:text/html");
            client.println();

            // use HTML autorefresh to update values on http
            // simple example, refresh and print now value of count
            // count will be count up by one each refresh
            client.println("<meta http-equiv='refresh' content='10; URL=/' />");
            count++;
            client.println("Count: " + (String)count);

            if (count > 10) {
              count = 0;
            }

            // the content of the HTTP response follows the header:
            client.print("Click <a href=\"/cocktail1\">here</a> to select cocktail #1 <br>");
            client.print("Click <a href=\"/cocktail2\">here</a> to select cocktail #2 <br>");

            // The HTTP response ends with another blank line:
            client.println();
            // break out of the while loop:
            break;
          } else {    // if you got a newline, then clear currentLine:
            currentLine = "";
          }
        } else if (c != '\r') {  // if you got anything else but a carriage return character,
          currentLine += c;      // add it to the end of the currentLine
        }


        // Check to see if the client request was "GET /H" or "GET /L":
        if (currentLine.endsWith("GET /cocktail1") && cocktailReady == true) {

          //cocktail = 1;
          cocktailReady == false;
          // stepper motor

          stepperTask(1, 32);       // alc#5
          delay(1000); // One second delay

          servoTask(5);
          delay(5000);
          servoTask(5);

          delay(2000); // One second delay

          stepperTask(1, 24);     // juice
          delay(1000); // One second delay
          pump(1, 10000);

          delay(5000);
          homed = false;
          end1.pressed = false;

          // call servo action
          //   servoTask(0);

          homed = false;
          end1.pressed = false;



          cocktail = 0;
          cocktailReady == true;

#ifdef debugEN
          Serial.println("cocktail 1 is ready");
          Serial.println("enjoy your drink and have nice time");
#endif
        }
        if (currentLine.endsWith("GET /cocktail2") && cocktailReady == true) {
          cocktailReady == false;
          cocktailReady == true;

#ifdef debugEN
          Serial.println("cocktail 2 is ready");
          Serial.println("enjoy your drink and have nice time");
#endif
        }
      }
    }
    // close the connection:
    client.stop();
    Serial.println("Client Disconnected.");
  }
}



void stepperTask(boolean dir, uint16_t mm) {
#ifdef debugEN
  Serial.printf("move cup by %d \n", mm);
#endif

  digitalWrite(enablePin, LOW); // Enables the motor to move in a particular direction
  delay(10);
  digitalWrite(dirPin, dir); // Enables the motor to move in a particular direction

  for (int16_t x = 0; x < (stepsMM * mm); x++) {
    digitalWrite(stepPin, HIGH);
    delayMicroseconds(stepperBreaktime);
    digitalWrite(stepPin, LOW);
    delayMicroseconds(stepperBreaktime);
  }

  digitalWrite(enablePin, HIGH); // Enables the motor to move in a particular direction

}

void servoTask(uint8_t servonum) {
#ifdef debugEN
  Serial.printf("Select Servo: %d \n", servonum);
#endif

  for (uint16_t pulselen = servomax; pulselen > servomin; pulselen--) {
    pwm.setPWM(servonum, 0, pulselen);
  }

  delay(servoBreaktime);

  for (uint16_t pulselen = servomin; pulselen < servomax; pulselen++) {
    pwm.setPWM(servonum, 0, pulselen);
  }
}

void pump(int nr, uint16_t breaktime_pump) {

  digitalWrite( pumps[nr], HIGH);

#ifdef debugEN
  Serial.printf("Starting pumps: %d for %d \n", pumps[nr], breaktime_pump);
#endif

  delay(breaktime_pump);

  digitalWrite( pumps[nr], LOW);

}
